#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using NUnit.Framework.Constraints;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.Common.UnitTests
{

	
	

	[TestFixture]
	public class Common_HL7DateFormat : BaseTest 
	{
		private System.DateTime _testDate;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();
			this._testDate = System.DateTime.Now;
		}

		[Test]
		public void ConvertHL7DateTime_4Char_Pass()
		{
			string tmpYear = this._testDate.ToString("yyyy");

			System.DateTime tmpDate = HL7DateFormat.ConvertHL7DateTime(tmpYear);
			
			Assert.AreEqual(tmpYear, tmpDate.Year.ToString("0000"), "Year");
		}

        [Test]
        public void ConvertHL7DateTime_6Char_Pass()
        {
            string tmpYear = this._testDate.ToString("yyyy");
            string tmpMonth = this._testDate.ToString("MM");
            System.DateTime tmpDate = System.DateTime.Now;
            // The exception is expected here.
            Assert.Throws<ArgumentOutOfRangeException>(
                delegate {tmpDate = HL7DateFormat.ConvertHL7DateTime(tmpYear + tmpMonth); }
                );
            Assert.AreEqual(expected: tmpYear, actual: tmpDate.Year.ToString("0000"), message: "Year");
            Assert.AreEqual(tmpMonth, tmpDate.Month.ToString("00"), "Month");
        }

	    [Test]
		public void ConvertHL7DateTime_8Char_Pass()
		{
			string tmpYear = this._testDate.ToString("yyyy");
			string tmpMonth = this._testDate.ToString("MM");
			string tmpDay = this._testDate.ToString("dd");

			System.DateTime tmpDate = HL7DateFormat.ConvertHL7DateTime(tmpYear+tmpMonth+tmpDay);

			Assert.AreEqual(tmpYear, tmpDate.Year.ToString("0000"), "Year");
			Assert.AreEqual(tmpMonth, tmpDate.Month.ToString("00"), "Month");
			Assert.AreEqual(tmpDay, tmpDate.Day.ToString("00"), "Day");
		}

		[Test]
		public void ConvertHL7DateTime_12Char_Pass()
		{
			string tmpYear = this._testDate.ToString("yyyy");
			string tmpMonth = this._testDate.ToString("MM");
			string tmpDay = this._testDate.ToString("dd");
			string tmpHour = this._testDate.ToString("hh");
			string tmpMin = this._testDate.ToString("mm");

			System.DateTime tmpDate = HL7DateFormat.ConvertHL7DateTime(tmpYear+tmpMonth+tmpDay+tmpHour+tmpMin);

			Assert.AreEqual(tmpYear, tmpDate.Year.ToString("0000"), "Year");
			Assert.AreEqual(tmpMonth, tmpDate.Month.ToString("00"), "Month");
			Assert.AreEqual(tmpDay, tmpDate.Day.ToString("00"), "Day");
			Assert.AreEqual(tmpHour, tmpDate.Hour.ToString("00"), "Hour");
			Assert.AreEqual(tmpMin, tmpDate.Minute.ToString("00"), "Min");
		}

		[Test]
		public void ConvertHL7DateTime_14Char_Pass()
		{
			string tmpYear = this._testDate.ToString("yyyy");
			string tmpMonth = this._testDate.ToString("MM");
			string tmpDay = this._testDate.ToString("dd");
			string tmpHour = this._testDate.ToString("hh");
			string tmpMin = this._testDate.ToString("mm");
			string tmpSec = this._testDate.ToString("ss");

			System.DateTime tmpDate = HL7DateFormat.ConvertHL7DateTime(tmpYear+tmpMonth+tmpDay+tmpHour+tmpMin+tmpSec);

			Assert.AreEqual(tmpYear, tmpDate.Year.ToString("0000"), "Year");
			Assert.AreEqual(tmpMonth, tmpDate.Month.ToString("00"), "Month");
			Assert.AreEqual(tmpDay, tmpDate.Day.ToString("00"), "Day");
			Assert.AreEqual(tmpHour, tmpDate.Hour.ToString("00"), "Hour");
			Assert.AreEqual(tmpMin, tmpDate.Minute.ToString("00"), "Min");
			Assert.AreEqual(tmpSec, tmpDate.Second.ToString("00"), "Sec");
		}

		[Test]
		public void ConvertHL7DateTime_17Char_Pass()
		{
			string tmpYear = this._testDate.ToString("yyyy");
			string tmpMonth = this._testDate.ToString("MM");
			string tmpDay = this._testDate.ToString("dd");
			string tmpHour = this._testDate.ToString("hh");
			string tmpMin = this._testDate.ToString("mm");
			string tmpSec = this._testDate.ToString("ss");

			//TODO: Remove this if it's not needed
			System.DateTime tmpDate = HL7DateFormat.ConvertHL7DateTime(tmpYear+tmpMonth+tmpDay+tmpHour+tmpMin+tmpSec+"XXX");

			Assert.AreEqual(tmpYear, tmpDate.Year.ToString("0000"), "Year");
			Assert.AreEqual(tmpMonth, tmpDate.Month.ToString("00"), "Month");
			Assert.AreEqual(tmpDay, tmpDate.Day.ToString("00"), "Day");
			Assert.AreEqual(tmpHour, tmpDate.Hour.ToString("00"), "Hour");
			Assert.AreEqual(tmpMin, tmpDate.Minute.ToString("00"), "Min");
		}

		[Test]
		public void ConvertHL7DateTime_19Char_Pass()
		{
			string tmpYear = this._testDate.ToString("yyyy");
			string tmpMonth = this._testDate.ToString("MM");
			string tmpDay = this._testDate.ToString("dd");
			string tmpHour = this._testDate.ToString("hh");
			string tmpMin = this._testDate.ToString("mm");
			string tmpSec = this._testDate.ToString("ss");

			//TODO: This will need to be updated when the timezone code is added properly
			System.DateTime tmpDate = HL7DateFormat.ConvertHL7DateTime(tmpYear+tmpMonth+tmpDay+tmpHour+tmpMin+tmpSec+"XXXXX");

			Assert.AreEqual(tmpYear, tmpDate.Year.ToString("0000"), "Year");
			Assert.AreEqual(tmpMonth, tmpDate.Month.ToString("00"), "Month");
			Assert.AreEqual(tmpDay, tmpDate.Day.ToString("00"), "Day");
			Assert.AreEqual(tmpHour, tmpDate.Hour.ToString("00"), "Hour");
			Assert.AreEqual(tmpMin, tmpDate.Minute.ToString("00"), "Min");
			Assert.AreEqual(tmpSec, tmpDate.Second.ToString("00"), "Sec");
		}

		[Test]
		public void ConvertHL7DateTime_AnyChar_Pass()
		{
			string tmpYear = this._testDate.ToString("yyyy");
			string tmpMonth = this._testDate.ToString("MM");
			string tmpDay = this._testDate.ToString("dd");

			//TODO: Will have to add conditions if code is updated to validate string length (of 8+)
			System.DateTime tmpDate = HL7DateFormat.ConvertHL7DateTime(tmpYear+tmpMonth+tmpDay+"X");

			Assert.AreEqual(tmpYear, tmpDate.Year.ToString("0000"), "Year");
			Assert.AreEqual(tmpMonth, tmpDate.Month.ToString("00"), "Month");
			Assert.AreEqual(tmpDay, tmpDate.Day.ToString("00"), "Day");
		}

        [Test]
        public void ConvertHL7DateTime_Fail()
        {
            const string tmpYear = "012345678901234567890"; //20 char string
            Assert.Throws<IndexOutOfRangeException>(delegate { HL7DateFormat.ConvertHL7DateTime(tmpYear); });
        }

	    [Test]
		public void ConvertHL7DateTimeToUniversalDateTime_Pass()
		{
			string tmpYear = this._testDate.ToString("yyyy");
			string tmpMonth = this._testDate.ToString("MM");
			string tmpDay = this._testDate.ToString("dd");
			string tmpHour = this._testDate.ToString("hh");
			string tmpMin = this._testDate.ToString("mm");

			System.DateTime tmpDate = HL7DateFormat.ConvertHL7DateTime(tmpYear+tmpMonth+tmpDay+tmpHour+tmpMin);

			System.DateTime utcDateTime = HL7DateFormat.ConvertHL7DateTimeToUniversalDateTime(tmpYear+tmpMonth+tmpDay+tmpHour+tmpMin);

			Assert.AreEqual(tmpDate.ToUniversalTime(),utcDateTime);
		}

		[Test]
		public void ConvertHL7DateTimeToUniversalDateTime_Fail_1()
		{
			string tmpYear = "012345678901234567890";	//20 char string
            Assert.Throws<IndexOutOfRangeException>(delegate { HL7DateFormat.ConvertHL7DateTimeToUniversalDateTime(tmpYear); });
		}

		[Test]
		public void ConvertHL7DateTimeToUniversalDateTime_Fail_2()
		{
            Assert.Throws<ArgumentNullException>(delegate { HL7DateFormat.ConvertHL7DateTimeToUniversalDateTime(null);});
		}
        
		[Test]
		public void ConvertDateTimeToHL7_Pass()
		{
			string tmpYear = this._testDate.ToString("yyyy");
			string tmpMonth = this._testDate.ToString("MM");
			string tmpDay = this._testDate.ToString("dd");
			string hl7DateTime = tmpYear+tmpMonth+tmpDay;

			System.DateTime tmpDate = HL7DateFormat.ConvertHL7DateTime(tmpYear+tmpMonth+tmpDay);

			Assert.AreEqual(hl7DateTime,HL7DateFormat.ConvertDateTimeToHL7(tmpDate));

		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void ConvertDateTimeToHL7_Fail()
		{}
	}
}
#endif
